<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-02-03 23:21
 */
interface DiscountcontrolDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Discountcontrol 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param discountcontrol primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Discountcontrol discountcontrol
 	 */
	public function insert($discountcontrol);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Discountcontrol discountcontrol
 	 */
	public function update($discountcontrol);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTotalFrom($value);

	public function queryByTotalTo($value);

	public function queryByDiscount($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByConditions($value);


	public function deleteByTotalFrom($value);

	public function deleteByTotalTo($value);

	public function deleteByDiscount($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByConditions($value);


}
?>